# This script was automatically generated from the 392-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libxine-dev 
- libxine-main1 
- libxine1 
- libxine1-dbg 
- libxine1c2 


Description :

A buffer overflow was discovered in the Real Media input plugin in 
xine-lib.  If a user were tricked into loading a specially crafted 
stream from a malicious server, the attacker could execute arbitrary 
code with the user\'s privileges.

Solution :

Upgrade to : 
- libxine-dev-1.1.2+repacked1-0ubuntu3.2 (Ubuntu 6.10)
- libxine-main1-1.1.2+repacked1-0ubuntu3.2 (Ubuntu 6.10)
- libxine1-1.1.2+repacked1-0ubuntu3.2 (Ubuntu 6.10)
- libxine1-dbg-1.1.2+repacked1-0ubuntu3.2 (Ubuntu 6.10)
- libxine1c2-1.0.1-1ubuntu10.7 (Ubuntu 5.10)



Risk factor : High
';

if (description) {
script_id(27977);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "392-1");
script_summary(english:"xine-lib vulnerability");
script_name(english:"USN392-1 : xine-lib vulnerability");
script_cve_id("CVE-2006-6172");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "libxine-dev", pkgver: "1.1.2+repacked1-0ubuntu3.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libxine-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libxine-dev-1.1.2+repacked1-0ubuntu3.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libxine-main1", pkgver: "1.1.2+repacked1-0ubuntu3.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libxine-main1-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libxine-main1-1.1.2+repacked1-0ubuntu3.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libxine1", pkgver: "1.1.2+repacked1-0ubuntu3.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libxine1-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libxine1-1.1.2+repacked1-0ubuntu3.2
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libxine1-dbg", pkgver: "1.1.2+repacked1-0ubuntu3.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libxine1-dbg-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libxine1-dbg-1.1.2+repacked1-0ubuntu3.2
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libxine1c2", pkgver: "1.0.1-1ubuntu10.7");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libxine1c2-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libxine1c2-1.0.1-1ubuntu10.7
');
}

if (w) { security_hole(port: 0, data: desc); }
