# This script was automatically generated from the 399-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- w3m 
- w3m-img 


Description :

A format string vulnerability was discovered in w3m.  If a user were 
tricked into visiting an HTTPS URL protected by a specially crafted SSL 
certificate, an attacker could execute arbitrary code with user 
privileges.

Solution :

Upgrade to : 
- w3m-0.5.1-4ubuntu2.6.10 (Ubuntu 6.10)
- w3m-img-0.5.1-4ubuntu2.6.10 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27987);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "399-1");
script_summary(english:"w3m vulnerabilities");
script_name(english:"USN399-1 : w3m vulnerabilities");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "w3m", pkgver: "0.5.1-4ubuntu2.6.10");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package w3m-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to w3m-0.5.1-4ubuntu2.6.10
');
}
found = ubuntu_check(osver: "6.10", pkgname: "w3m-img", pkgver: "0.5.1-4ubuntu2.6.10");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package w3m-img-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to w3m-img-0.5.1-4ubuntu2.6.10
');
}

if (w) { security_hole(port: 0, data: desc); }
