# This script was automatically generated from the 405-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- fetchmail 
- fetchmail-ssl 
- fetchmailconf 


Description :

It was discovered that fetchmail did not correctly require TLS 
negotiation in certain situations.  This would result in a user\'s 
unencrypted password being sent across the network.

If fetchmail has been configured to use the "sslproto tls1", 
"sslcertck", or "sslfingerprint" options with a server that does not 
correctly support TLS negotiation, this update may cause fetchmail to 
(correctly) abort authentication.

Solution :

Upgrade to : 
- fetchmail-6.3.4-1ubuntu4.1 (Ubuntu 6.10)
- fetchmail-ssl-6.2.5-13ubuntu3.3 (Ubuntu 5.10)
- fetchmailconf-6.3.4-1ubuntu4.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(27993);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "405-1");
script_summary(english:"fetchmail vulnerability");
script_name(english:"USN405-1 : fetchmail vulnerability");
script_cve_id("CVE-2006-5867");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "fetchmail", pkgver: "6.3.4-1ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package fetchmail-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to fetchmail-6.3.4-1ubuntu4.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "fetchmail-ssl", pkgver: "6.2.5-13ubuntu3.3");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package fetchmail-ssl-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to fetchmail-ssl-6.2.5-13ubuntu3.3
');
}
found = ubuntu_check(osver: "6.10", pkgname: "fetchmailconf", pkgver: "6.3.4-1ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package fetchmailconf-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to fetchmailconf-6.3.4-1ubuntu4.1
');
}

if (w) { security_hole(port: 0, data: desc); }
