# This script was automatically generated from the 411-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libsoup2.2-8 
- libsoup2.2-dev 
- libsoup2.2-doc 


Description :

Roland Lezuo and Josselin Mouette discovered that the HTTP server code 
in libsoup did not correctly verify request headers.  Remote attackers 
could crash applications using libsoup by sending a crafted HTTP 
request, resulting in a denial of service.

Solution :

Upgrade to : 
- libsoup2.2-8-2.2.96-0ubuntu2.1 (Ubuntu 6.10)
- libsoup2.2-dev-2.2.96-0ubuntu2.1 (Ubuntu 6.10)
- libsoup2.2-doc-2.2.96-0ubuntu2.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28000);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "411-1");
script_summary(english:"libsoup vulnerability");
script_name(english:"USN411-1 : libsoup vulnerability");
script_cve_id("CVE-2006-5876");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "libsoup2.2-8", pkgver: "2.2.96-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libsoup2.2-8-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libsoup2.2-8-2.2.96-0ubuntu2.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libsoup2.2-dev", pkgver: "2.2.96-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libsoup2.2-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libsoup2.2-dev-2.2.96-0ubuntu2.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libsoup2.2-doc", pkgver: "2.2.96-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libsoup2.2-doc-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libsoup2.2-doc-2.2.96-0ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
