# This script was automatically generated from the 412-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- geoip-bin 
- libgeoip-dev 
- libgeoip1 


Description :

Dean Gaudet discovered that the GeoIP update tool did not validate the 
filename responses from the update server.  A malicious server, or 
man-in-the-middle system posing as a server, could write to arbitrary 
files with user privileges.

Solution :

Upgrade to : 
- geoip-bin-1.3.17-1ubuntu0.1 (Ubuntu 6.10)
- libgeoip-dev-1.3.17-1ubuntu0.1 (Ubuntu 6.10)
- libgeoip1-1.3.17-1ubuntu0.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28001);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "412-1");
script_summary(english:"GeoIP vulnerability");
script_name(english:"USN412-1 : GeoIP vulnerability");
script_cve_id("CVE-2007-0159");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "geoip-bin", pkgver: "1.3.17-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package geoip-bin-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to geoip-bin-1.3.17-1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libgeoip-dev", pkgver: "1.3.17-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgeoip-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libgeoip-dev-1.3.17-1ubuntu0.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libgeoip1", pkgver: "1.3.17-1ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgeoip1-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libgeoip1-1.3.17-1ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
