# This script was automatically generated from the 413-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- bluez-cups 
- bluez-pcmcia-support 
- bluez-utils 


Description :

A flaw was discovered in the HID daemon of bluez-utils.  A remote 
attacker could gain control of the mouse and keyboard if hidd was 
enabled.  This does not affect a default Ubuntu installation, since hidd 
is normally disabled.

Solution :

Upgrade to : 
- bluez-cups-2.20-0ubuntu3.1 (Ubuntu 5.10)
- bluez-pcmcia-support-2.20-0ubuntu3.1 (Ubuntu 5.10)
- bluez-utils-2.20-0ubuntu3.1 (Ubuntu 5.10)



Risk factor : High
';

if (description) {
script_id(28002);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "413-1");
script_summary(english:"BlueZ vulnerability");
script_name(english:"USN413-1 : BlueZ vulnerability");
script_cve_id("CVE-2006-6899");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "5.10", pkgname: "bluez-cups", pkgver: "2.20-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package bluez-cups-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to bluez-cups-2.20-0ubuntu3.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "bluez-pcmcia-support", pkgver: "2.20-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package bluez-pcmcia-support-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to bluez-pcmcia-support-2.20-0ubuntu3.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "bluez-utils", pkgver: "2.20-0ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package bluez-utils-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to bluez-utils-2.20-0ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
