# This script was automatically generated from the 421-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- moin 
- moinmoin-common 
- python-moinmoin 
- python2.3-moinmoin 
- python2.4-moinmoin 


Description :

A flaw was discovered in MoinMoin\'s page name sanitizer which could lead 
to a cross-site scripting attack.  By tricking a user into viewing a 
crafted MoinMoin page, an attacker could execute arbitrary JavaScript as 
the current MoinMoin user, possibly exposing the user\'s authentication 
information for the domain where MoinMoin was hosted.

Solution :

Upgrade to : 
- moin-1.2.4-1ubuntu2.1 (Ubuntu 5.10)
- moinmoin-common-1.5.3-1ubuntu1.1 (Ubuntu 6.10)
- python-moinmoin-1.5.3-1ubuntu1.1 (Ubuntu 6.10)
- python2.3-moinmoin-1.3.4-6ubuntu1.1 (Ubuntu 5.10)
- python2.4-moinmoin-1.5.3-1ubuntu1.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28013);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "421-1");
script_summary(english:"MoinMoin vulnerability");
script_name(english:"USN421-1 : MoinMoin vulnerability");
script_cve_id("CVE-2007-0857");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "5.10", pkgname: "moin", pkgver: "1.2.4-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package moin-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to moin-1.2.4-1ubuntu2.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "moinmoin-common", pkgver: "1.5.3-1ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package moinmoin-common-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to moinmoin-common-1.5.3-1ubuntu1.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "python-moinmoin", pkgver: "1.5.3-1ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package python-moinmoin-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to python-moinmoin-1.5.3-1ubuntu1.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "python2.3-moinmoin", pkgver: "1.3.4-6ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package python2.3-moinmoin-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to python2.3-moinmoin-1.3.4-6ubuntu1.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "python2.4-moinmoin", pkgver: "1.5.3-1ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package python2.4-moinmoin-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to python2.4-moinmoin-1.5.3-1ubuntu1.1
');
}

if (w) { security_hole(port: 0, data: desc); }
