# This script was automatically generated from the 453-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libx11-6 
- libx11-6-dbg 
- libx11-data 
- libx11-dev 


Description :

Multiple integer overflows were found in the XGetPixel function of 
libx11.  If a user were tricked into opening a specially crafted XWD 
image, remote attackers could execute arbitrary code with user 
privileges.

Solution :

Upgrade to : 
- libx11-6-1.0.3-0ubuntu4.1 (Ubuntu 6.10)
- libx11-6-dbg-1.0.3-0ubuntu4.1 (Ubuntu 6.10)
- libx11-data-1.0.3-0ubuntu4.1 (Ubuntu 6.10)
- libx11-dev-1.0.3-0ubuntu4.1 (Ubuntu 6.10)



Risk factor : High
';

if (description) {
script_id(28050);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "453-1");
script_summary(english:"X.org vulnerability");
script_name(english:"USN453-1 : X.org vulnerability");
script_cve_id("CVE-2007-1667");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "6.10", pkgname: "libx11-6", pkgver: "1.0.3-0ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libx11-6-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libx11-6-1.0.3-0ubuntu4.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libx11-6-dbg", pkgver: "1.0.3-0ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libx11-6-dbg-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libx11-6-dbg-1.0.3-0ubuntu4.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libx11-data", pkgver: "1.0.3-0ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libx11-data-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libx11-data-1.0.3-0ubuntu4.1
');
}
found = ubuntu_check(osver: "6.10", pkgname: "libx11-dev", pkgver: "1.0.3-0ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libx11-dev-',found,' is vulnerable in Ubuntu 6.10
Upgrade it to libx11-dev-1.0.3-0ubuntu4.1
');
}

if (w) { security_hole(port: 0, data: desc); }
