# This script was automatically generated from the 461-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- quagga 
- quagga-doc 


Description :

It was discovered that Quagga did not correctly verify length 
information sent from configured peers.  Remote malicious peers could 
send a specially crafted UPDATE message which would cause bgpd to abort, 
leading to a denial of service.

Solution :

Upgrade to : 
- quagga-0.99.6-2ubuntu3.1 (Ubuntu 7.04)
- quagga-doc-0.99.6-2ubuntu3.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28061);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "461-1");
script_summary(english:"Quagga vulnerability");
script_name(english:"USN461-1 : Quagga vulnerability");
script_cve_id("CVE-2007-1995");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "quagga", pkgver: "0.99.6-2ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package quagga-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to quagga-0.99.6-2ubuntu3.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "quagga-doc", pkgver: "0.99.6-2ubuntu3.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package quagga-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to quagga-doc-0.99.6-2ubuntu3.1
');
}

if (w) { security_hole(port: 0, data: desc); }
