# This script was automatically generated from the 474-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- xscreensaver 
- xscreensaver-data 
- xscreensaver-data-extra 
- xscreensaver-gl 
- xscreensaver-gl-extra 


Description :

It was discovered that xscreensaver did not correctly validate the
return values from network authentication systems such as LDAP or NIS.
A local attacker could bypass a locked screen if they were able to
interrupt network connectivity.

Solution :

Upgrade to : 
- xscreensaver-4.24-5ubuntu2.1 (Ubuntu 7.04)
- xscreensaver-data-4.24-5ubuntu2.1 (Ubuntu 7.04)
- xscreensaver-data-extra-4.24-5ubuntu2.1 (Ubuntu 7.04)
- xscreensaver-gl-4.24-5ubuntu2.1 (Ubuntu 7.04)
- xscreensaver-gl-extra-4.24-5ubuntu2.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28075);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "474-1");
script_summary(english:"xscreensaver vulnerability");
script_name(english:"USN474-1 : xscreensaver vulnerability");
script_cve_id("CVE-2007-1859");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "xscreensaver", pkgver: "4.24-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xscreensaver-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xscreensaver-4.24-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "xscreensaver-data", pkgver: "4.24-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xscreensaver-data-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xscreensaver-data-4.24-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "xscreensaver-data-extra", pkgver: "4.24-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xscreensaver-data-extra-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xscreensaver-data-extra-4.24-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "xscreensaver-gl", pkgver: "4.24-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xscreensaver-gl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xscreensaver-gl-4.24-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "xscreensaver-gl-extra", pkgver: "4.24-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xscreensaver-gl-extra-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xscreensaver-gl-extra-4.24-5ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
