# This script was automatically generated from the 480-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- gimp 
- gimp-data 
- gimp-dbg 
- gimp-helpbrowser 
- gimp-python 
- gimp-svg 
- libgimp2.0 
- libgimp2.0-dev 
- libgimp2.0-doc 


Description :

Stefan Cornelius discovered that Gimp could miscalculate the size of heap
buffers when processing PSD images.  By tricking a user into opening a
specially crafted PSD file with Gimp, an attacker could exploit this to
execute arbitrary code with the user\'s privileges.

Solution :

Upgrade to : 
- gimp-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- gimp-data-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- gimp-dbg-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- gimp-helpbrowser-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- gimp-python-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- gimp-svg-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- libgimp2.0-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- libgimp2.0-dev-2.2.13-1ubuntu4.2 (Ubuntu 7.04)
- libgimp2.0-doc-2.2.13-1ubuntu4.2 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28081);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "480-1");
script_summary(english:"Gimp vulnerability");
script_name(english:"USN480-1 : Gimp vulnerability");
script_cve_id("CVE-2007-2949");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "gimp", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gimp-data", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-data-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-data-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gimp-dbg", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-dbg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-dbg-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gimp-helpbrowser", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-helpbrowser-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-helpbrowser-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gimp-python", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-python-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-python-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gimp-svg", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gimp-svg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gimp-svg-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libgimp2.0", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgimp2.0-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libgimp2.0-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libgimp2.0-dev", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgimp2.0-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libgimp2.0-dev-2.2.13-1ubuntu4.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libgimp2.0-doc", pkgver: "2.2.13-1ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgimp2.0-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libgimp2.0-doc-2.2.13-1ubuntu4.2
');
}

if (w) { security_hole(port: 0, data: desc); }
