# This script was automatically generated from the 484-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- curl 
- libcurl3 
- libcurl3-dbg 
- libcurl3-dev 
- libcurl3-gnutls 
- libcurl3-gnutls-dev 
- libcurl3-openssl-dev 


Description :

It was discovered that the GnuTLS certificate verification methods
implemented in Curl did not check for expiration and activation dates.
When performing validations, tools using libcurl3-gnutls would
incorrectly allow connections to sites using expired certificates.

Solution :

Upgrade to : 
- curl-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-dbg-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-dev-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-gnutls-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-gnutls-dev-7.15.5-1ubuntu2.1 (Ubuntu 7.04)
- libcurl3-openssl-dev-7.15.5-1ubuntu2.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28085);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "484-1");
script_summary(english:"curl vulnerability");
script_name(english:"USN484-1 : curl vulnerability");
script_cve_id("CVE-2007-3564");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "curl", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package curl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to curl-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3-dbg", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-dbg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-dbg-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3-dev", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-dev-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3-gnutls", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-gnutls-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-gnutls-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3-gnutls-dev", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-gnutls-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-gnutls-dev-7.15.5-1ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libcurl3-openssl-dev", pkgver: "7.15.5-1ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libcurl3-openssl-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libcurl3-openssl-dev-7.15.5-1ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
