# This script was automatically generated from the 495-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libqt3-compat-headers 
- libqt3-headers 
- libqt3-i18n 
- libqt3-mt 
- libqt3-mt-dev 
- libqt3-mt-mysql 
- libqt3-mt-odbc 
- libqt3-mt-psql 
- libqt3-mt-sqlite 
- qt-x11-free-dbg 
- qt3-apps-dev 
- qt3-assistant 
- qt3-designer 
- qt3-dev-tools 
- qt3-dev-tools-compat 
- qt3-dev-tools-embedded 
- qt3-doc 
- qt3-examples 
- qt3-linguist 
- qt3-qtconfig 


Description :

Several format string vulnerabilities have been discovered in Qt
warning messages. By causing an application to process specially
crafted input data which triggered Qt warnings, this could be
exploited to execute arbitrary code with the privilege of the user
running the application.

Solution :

Upgrade to : 
- libqt3-compat-headers-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-headers-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-i18n-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-dev-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-mysql-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-odbc-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-psql-3.3.8really3.3.7-0ubuntu5.1 (Ubuntu 7.04)
- libqt3-mt-sqlite-3.3.8re
[...]


Risk factor : High
';

if (description) {
script_id(28097);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "495-1");
script_summary(english:"Qt vulnerability");
script_name(english:"USN495-1 : Qt vulnerability");
script_cve_id("CVE-2007-3388");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libqt3-compat-headers", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-compat-headers-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-compat-headers-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-headers", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-headers-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-headers-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-i18n", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-i18n-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-i18n-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt-dev", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-dev-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt-mysql", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-mysql-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-mysql-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt-odbc", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-odbc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-odbc-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt-psql", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-psql-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-psql-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libqt3-mt-sqlite", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libqt3-mt-sqlite-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libqt3-mt-sqlite-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt-x11-free-dbg", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt-x11-free-dbg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt-x11-free-dbg-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-apps-dev", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-apps-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-apps-dev-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-assistant", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-assistant-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-assistant-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-designer", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-designer-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-designer-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-dev-tools", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-dev-tools-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-dev-tools-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-dev-tools-compat", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-dev-tools-compat-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-dev-tools-compat-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-dev-tools-embedded", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-dev-tools-embedded-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-dev-tools-embedded-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-doc", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-doc-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-examples", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-examples-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-examples-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-linguist", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-linguist-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-linguist-3.3.8really3.3.7-0ubuntu5.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "qt3-qtconfig", pkgver: "3.3.8really3.3.7-0ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package qt3-qtconfig-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to qt3-qtconfig-3.3.8really3.3.7-0ubuntu5.1
');
}

if (w) { security_hole(port: 0, data: desc); }
