# This script was automatically generated from the 501-2 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- gs 
- gs-gpl 


Description :

USN-501-1 fixed vulnerabilities in Jasper.  This update provides the
corresponding update for the Jasper internal to Ghostscript.

Original advisory details:

 It was discovered that Jasper did not correctly handle corrupted JPEG2000
 images. By tricking a user into opening a specially crafted JPG, a
 remote attacker could cause the application using libjasper to crash,
 resulting in a denial of service.

Solution :

Upgrade to : 
- gs-8.54.dfsg.1-5ubuntu0.1 (Ubuntu 7.04)
- gs-gpl-8.54.dfsg.1-5ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28105);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "501-2");
script_summary(english:"Ghostscript vulnerability");
script_name(english:"USN501-2 : Ghostscript vulnerability");
script_cve_id("CVE-2007-2721");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "gs", pkgver: "8.54.dfsg.1-5ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gs-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gs-8.54.dfsg.1-5ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "gs-gpl", pkgver: "8.54.dfsg.1-5ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gs-gpl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to gs-gpl-8.54.dfsg.1-5ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
