# This script was automatically generated from the 505-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- vim 
- vim-common 
- vim-doc 
- vim-full 
- vim-gnome 
- vim-gtk 
- vim-gui-common 
- vim-perl 
- vim-python 
- vim-ruby 
- vim-runtime 
- vim-tcl 
- vim-tiny 


Description :

Ulf Harnhammar discovered that vim does not properly sanitise the
"helptags_one()" function when running the "helptags" command.
By tricking a user into running a crafted help file, a remote attacker
could execute arbitrary code with the user\'s privileges.

Solution :

Upgrade to : 
- vim-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-common-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-doc-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-full-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-gnome-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-gtk-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-gui-common-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-perl-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-python-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-ruby-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-runtime-7.0-164+1ubuntu7.2 (Ubuntu 7.04)
- vim-
[...]


Risk factor : High
';

if (description) {
script_id(28109);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "505-1");
script_summary(english:"vim vulnerability");
script_name(english:"USN505-1 : vim vulnerability");
script_cve_id("CVE-2007-2953");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "vim", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-common", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-common-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-common-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-doc", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-doc-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-full", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-full-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-full-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-gnome", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-gnome-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-gnome-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-gtk", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-gtk-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-gtk-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-gui-common", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-gui-common-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-gui-common-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-perl", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-perl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-perl-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-python", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-python-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-python-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-ruby", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-ruby-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-ruby-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-runtime", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-runtime-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-runtime-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-tcl", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-tcl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-tcl-7.0-164+1ubuntu7.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "vim-tiny", pkgver: "7.0-164+1ubuntu7.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package vim-tiny-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to vim-tiny-7.0-164+1ubuntu7.2
');
}

if (w) { security_hole(port: 0, data: desc); }
