# This script was automatically generated from the 519-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- elinks 
- elinks-lite 


Description :

Kalle Olavi Niemitalo discovered that if elinks makes a POST request
to an HTTPS URL through a proxy, information may be sent in clear-text
between elinks and the proxy.  Attackers with access to the network
could steal sensitive information (such as passwords).

Solution :

Upgrade to : 
- elinks-0.11.1-1.2ubuntu2.2 (Ubuntu 7.04)
- elinks-lite-0.11.1-1.2ubuntu2.2 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28124);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "519-1");
script_summary(english:"elinks vulnerability");
script_name(english:"USN519-1 : elinks vulnerability");
script_cve_id("CVE-2007-5034");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "elinks", pkgver: "0.11.1-1.2ubuntu2.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package elinks-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to elinks-0.11.1-1.2ubuntu2.2
');
}
found = ubuntu_check(osver: "7.04", pkgname: "elinks-lite", pkgver: "0.11.1-1.2ubuntu2.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package elinks-lite-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to elinks-lite-0.11.1-1.2ubuntu2.2
');
}

if (w) { security_hole(port: 0, data: desc); }
