# This script was automatically generated from the 522-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libssl-dev 
- libssl0.9.8 
- libssl0.9.8-dbg 
- openssl 


Description :

It was discovered that OpenSSL did not correctly perform Montgomery
multiplications.  Local attackers might be able to reconstruct RSA
private keys by examining another user\'s OpenSSL processes. (CVE-2007-3108)

Moritz Jodeit discovered that OpenSSL\'s SSL_get_shared_ciphers function
did not correctly check the size of the buffer it was writing to.
A remote attacker could exploit this to write one NULL byte past the end of
an application\'s cipher list buffer, possibly leading to arbitrary code
execution or a denial of service. (CVE-2007-5135)

Solution :

Upgrade to : 
- libssl-dev-0.9.8c-4ubuntu0.1 (Ubuntu 7.04)
- libssl0.9.8-0.9.8c-4ubuntu0.1 (Ubuntu 7.04)
- libssl0.9.8-dbg-0.9.8c-4ubuntu0.1 (Ubuntu 7.04)
- openssl-0.9.8c-4ubuntu0.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28127);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "522-1");
script_summary(english:"OpenSSL vulnerabilities");
script_name(english:"USN522-1 : OpenSSL vulnerabilities");
script_cve_id("CVE-2007-3108","CVE-2007-5135");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libssl-dev", pkgver: "0.9.8c-4ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libssl-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libssl-dev-0.9.8c-4ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libssl0.9.8", pkgver: "0.9.8c-4ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libssl0.9.8-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libssl0.9.8-0.9.8c-4ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libssl0.9.8-dbg", pkgver: "0.9.8c-4ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libssl0.9.8-dbg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libssl0.9.8-dbg-0.9.8c-4ubuntu0.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "openssl", pkgver: "0.9.8c-4ubuntu0.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package openssl-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to openssl-0.9.8c-4ubuntu0.1
');
}

if (w) { security_hole(port: 0, data: desc); }
