# This script was automatically generated from the 533-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- bsdutils 
- mount 
- util-linux 
- util-linux-locales 


Description :

Ludwig Nussel discovered that mount and umount did not properly
drop privileges when using helper programs. Local attackers may be
able to bypass security restrictions and gain root privileges using
programs such as mount.nfs or mount.cifs.

Solution :

Upgrade to : 
- bsdutils-2.12r-17ubuntu2.1 (Ubuntu 7.04)
- mount-2.12r-17ubuntu2.1 (Ubuntu 7.04)
- util-linux-2.12r-17ubuntu2.1 (Ubuntu 7.04)
- util-linux-locales-2.12r-17ubuntu2.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(28139);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "533-1");
script_summary(english:"util-linux vulnerability");
script_name(english:"USN533-1 : util-linux vulnerability");
script_cve_id("CVE-2007-5191");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "bsdutils", pkgver: "2.12r-17ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package bsdutils-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to bsdutils-2.12r-17ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "mount", pkgver: "2.12r-17ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package mount-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to mount-2.12r-17ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "util-linux", pkgver: "2.12r-17ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package util-linux-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to util-linux-2.12r-17ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "util-linux-locales", pkgver: "2.12r-17ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package util-linux-locales-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to util-linux-locales-2.12r-17ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
