# This script was automatically generated from the 537-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

The remote package "gnome-screensaver" is missing a security patch.

Description :

Jens Askengren discovered that gnome-screensaver became confused when
running under Compiz, and could lose keyboard lock focus.  A local
attacker could exploit this to bypass the user\'s locked screen saver.

Solution :

Upgrade to : 
- gnome-screensaver-2.20.0-0ubuntu4.2 (Ubuntu 7.10)



Risk factor : High
';

if (description) {
script_id(28143);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "537-1");
script_summary(english:"gnome-screensaver vulnerability");
script_name(english:"USN537-1 : gnome-screensaver vulnerability");
script_cve_id("CVE-2007-3920");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.10", pkgname: "gnome-screensaver", pkgver: "2.20.0-0ubuntu4.2");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnome-screensaver-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to gnome-screensaver-2.20.0-0ubuntu4.2
');
}

if (w) { security_hole(port: 0, data: desc); }
