# This script was automatically generated from the 540-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- flac 
- libflac++-dev 
- libflac++5c2 
- libflac++6 
- libflac-dev 
- libflac-doc 
- libflac7 
- libflac8 
- liboggflac++-dev 
- liboggflac++2c2 
- liboggflac-dev 
- liboggflac3 
- xmms-flac 


Description :

Sean de Regge discovered that flac did not properly perform bounds
checking in many situations. An attacker could send a specially crafted
FLAC audio file and execute arbitrary code as the user or cause a denial
of service in flac or applications that link against flac.

Solution :

Upgrade to : 
- flac-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- libflac++-dev-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- libflac++5c2-1.1.2-5ubuntu2.1 (Ubuntu 7.04)
- libflac++6-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- libflac-dev-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- libflac-doc-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- libflac7-1.1.2-5ubuntu2.1 (Ubuntu 7.04)
- libflac8-1.1.4-3ubuntu1.1 (Ubuntu 7.10)
- liboggflac++-dev-1.1.2-5ubuntu2.1 (Ubuntu 7.04)
- liboggflac++2c2-1.1.2-5ubuntu2.1 (Ubuntu 7.04)
- liboggflac-dev-1.1.2-5ubuntu2.1 (Ubuntu 7.04)
-
[...]


Risk factor : High
';

if (description) {
script_id(28208);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2007 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "540-1");
script_summary(english:"flac vulnerability");
script_name(english:"USN540-1 : flac vulnerability");
script_cve_id("CVE-2007-4619");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.10", pkgname: "flac", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package flac-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to flac-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libflac++-dev", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac++-dev-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libflac++-dev-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libflac++5c2", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac++5c2-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libflac++5c2-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libflac++6", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac++6-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libflac++6-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libflac-dev", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac-dev-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libflac-dev-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libflac-doc", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac-doc-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libflac-doc-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libflac7", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac7-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libflac7-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libflac8", pkgver: "1.1.4-3ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libflac8-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libflac8-1.1.4-3ubuntu1.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "liboggflac++-dev", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package liboggflac++-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to liboggflac++-dev-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "liboggflac++2c2", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package liboggflac++2c2-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to liboggflac++2c2-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "liboggflac-dev", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package liboggflac-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to liboggflac-dev-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "liboggflac3", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package liboggflac3-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to liboggflac3-1.1.2-5ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "xmms-flac", pkgver: "1.1.2-5ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package xmms-flac-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to xmms-flac-1.1.2-5ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
