# This script was automatically generated from the 561-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libpt-1.10.0 
- libpt-dbg 
- libpt-dev 
- libpt-doc 
- libpt-plugins-alsa 
- libpt-plugins-avc 
- libpt-plugins-dc 
- libpt-plugins-oss 
- libpt-plugins-v4l 
- libpt-plugins-v4l2 


Description :

Jose Miguel Esparza discovered that pwlib did not correctly handle large
string lengths.  A remote attacker could send specially crafted packets to
applications linked against pwlib (e.g. Ekiga) causing them to crash, leading
to a denial of service.

Solution :

Upgrade to : 
- libpt-1.10.0-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-dbg-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-dev-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-doc-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-alsa-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-avc-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-dc-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-oss-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-v4l-1.10.10-0ubuntu2.1 (Ubuntu 7.10)
- libpt-plugins-v4l2-1.10.10-0ubuntu2.1 (Ubuntu 7
[...]


Risk factor : High
';

if (description) {
script_id(29917);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2008 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "561-1");
script_summary(english:"pwlib vulnerability");
script_name(english:"USN561-1 : pwlib vulnerability");
script_cve_id("CVE-2007-4897");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.10", pkgname: "libpt-1.10.0", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-1.10.0-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-1.10.0-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-dbg", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-dbg-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-dbg-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-dev", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-dev-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-dev-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-doc", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-doc-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-doc-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-alsa", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-alsa-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-alsa-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-avc", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-avc-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-avc-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-dc", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-dc-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-dc-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-oss", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-oss-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-oss-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-v4l", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-v4l-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-v4l-1.10.10-0ubuntu2.1
');
}
found = ubuntu_check(osver: "7.10", pkgname: "libpt-plugins-v4l2", pkgver: "1.10.10-0ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libpt-plugins-v4l2-',found,' is vulnerable in Ubuntu 7.10
Upgrade it to libpt-plugins-v4l2-1.10.10-0ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
