# This script was automatically generated from the 562-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- libopal-2.2.0 
- libopal-dbg 
- libopal-dev 
- libopal-doc 
- simpleopal 


Description :

Jose Miguel Esparza discovered that certain SIP headers were not correctly
validated.  A remote attacker could send a specially crafted packet to
an application linked against opal (e.g. Ekiga) causing it to crash, leading
to a denial of service.

Solution :

Upgrade to : 
- libopal-2.2.0-2.2.3.dfsg-2ubuntu2.1 (Ubuntu 7.04)
- libopal-dbg-2.2.3.dfsg-2ubuntu2.1 (Ubuntu 7.04)
- libopal-dev-2.2.3.dfsg-2ubuntu2.1 (Ubuntu 7.04)
- libopal-doc-2.2.3.dfsg-2ubuntu2.1 (Ubuntu 7.04)
- simpleopal-2.2.3.dfsg-2ubuntu2.1 (Ubuntu 7.04)



Risk factor : High
';

if (description) {
script_id(29918);
script_version("$Revision: 1.1 $");
script_copyright("Ubuntu Security Notice (C) 2008 Canonical, Inc. / NASL script (C) 2007 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "562-1");
script_summary(english:"opal vulnerability");
script_name(english:"USN562-1 : opal vulnerability");
script_cve_id("CVE-2007-4924");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "7.04", pkgname: "libopal-2.2.0", pkgver: "2.2.3.dfsg-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libopal-2.2.0-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libopal-2.2.0-2.2.3.dfsg-2ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libopal-dbg", pkgver: "2.2.3.dfsg-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libopal-dbg-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libopal-dbg-2.2.3.dfsg-2ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libopal-dev", pkgver: "2.2.3.dfsg-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libopal-dev-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libopal-dev-2.2.3.dfsg-2ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "libopal-doc", pkgver: "2.2.3.dfsg-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libopal-doc-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to libopal-doc-2.2.3.dfsg-2ubuntu2.1
');
}
found = ubuntu_check(osver: "7.04", pkgname: "simpleopal", pkgver: "2.2.3.dfsg-2ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package simpleopal-',found,' is vulnerable in Ubuntu 7.04
Upgrade it to simpleopal-2.2.3.dfsg-2ubuntu2.1
');
}

if (w) { security_hole(port: 0, data: desc); }
