#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# It is released under the GNU Public Licence
#

 desc["english"] = "
Synopsis :

There is an unknown service running on the remote host. 

Description :

Nessus was unable to identify a service on the remote host even though
it returned a banner of some type. 

Risk factor : 

None";


if(description)
{
 script_id(11154);
 script_version ("$Revision: 1.34 $");

 name["english"] = "Unknown services banners";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Displays the unknown services banners";
 script_summary(english:summary["english"]);
 
 script_category(ACT_END); 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Service detection";
 script_family(english:family["english"]);
 script_dependencie(
   "PC_anywhere_tcp.nasl",
   "SHN_discard.nasl",
   "X.nasl",
   "apcnisd_detect.nasl",
   "alcatel_backdoor_switch.nasl",
   "asip-status.nasl",
   "auth_enabled.nasl",
   "bugbear.nasl",
   "cifs445.nasl",
   "cp-firewall-auth.nasl",
   "dcetest.nasl",
   "dns_server.nasl",
   "echo.nasl",
   "find_service1.nasl",
   "find_service2.nasl",
   "mldonkey_telnet.nasl",
   "mssqlserver_detect.nasl",
   "mysql_version.nasl",
   "nessus_detect.nasl",
   "qmtp_detect.nasl",
   "radmin_detect.nasl",
   "rpc_portmap.nasl",
   "rpcinfo.nasl",
   "rsh.nasl",
   "rtsp_detect.nasl",
   "telnet.nasl",
   "xtel_detect.nasl",
   "xtelw_detect.nasl");
   if (NASL_LEVEL >= 3000)
   {
    script_dependencies (
    "veritas_agent_detect.nasl",
    "veritas_netbackup_vmd_detect.nasl",
    "veritas_netbackup_detect.nasl",
    "nagios_statd_detect.nasl",
    "ipswitch_imserver_detect.nasl",
    "ipswitch_imclient_detect.nasl",
    "hp_openview_ovalarmsrv.nasl",
    "hp_openview_ovtopmd.nasl",
    "hp_openview_ovuispmd.nasl",
    "hp_data_protector_installed.nasl",
    "dotnet_remoting_services_detect.nasl",
    "aximilter_detect.nasl"
     );
   }
 script_require_ports("Services/unknown");
 exit(0);
}

#
include("misc_func.inc");
include("dump.inc");

if ( get_kb_item("global_settings/disable_service_discovery") ) exit(0);


port = get_unknown_svc();
if (! port) exit(0);
if (! get_port_state(port)) exit(0);
if (port == 139) exit(0);	# Avoid silly messages
if (! service_is_unknown(port: port)) exit(0);

a = get_unknown_banner2(port: port, dontfetch: 1);
if (isnull(a)) exit(0);
banner = a[0]; type = a[1];
if (isnull(banner)) exit(0);

h = hexdump(ddata: banner);
if( strlen(banner) >= 3 )
{
  # See if the service is maybe SSL-wrapped.
  test_ssl = get_preference("Service detection[radio]:Test SSL based services");
  encaps = get_kb_item("Transports/TCP/"+port);
  first5 = substr(banner, 0, 4);

  if (
    (strlen(test_ssl) && "All" >!< test_ssl) &&
    encaps == ENCAPS_IP &&
    (
      # nb: TLSv1 alert of some type.
      first5 == raw_string(0x15, 0x03, 0x01, 0x00, 0x02) ||
      # nb: SSLv2 alert of some type.
      first5 == raw_string(0x80, 0x03, 0x00, 0x00, 0x01)
    )
  )
  {
    info = string(
      "The service on this port appears to be encrypted with SSL. If you\n",
      "would like Nessus to try harder to detect it, change the 'Test SSL\n",
      "based services' preference to 'All' and re-run the scan.\n"
    );
  }
  else
  {
    h = str_replace(find:'\n', replace:'\n           ', string:h);
    info = string(
      "If you know what this service is, please send a description along\n",
      "with the following output to svc-signatures@nessus.org :\n",
      "\n",
      "  Port :   ", port, "\n",
      "  Type :   ", type, "\n",
      "  Banner : ", h, "\n"
    );
  }
  report = string(
    desc["english"],
    "\n\n",
    "Plugin output :\n",
    "\n",
    info
  );
  security_note(port:port, data:report);
}
