#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

 desc["english"] = "
Synopsis :

The remote web server contains a CGI script that may allow arbitrary
uploads. 

Description :

The Upload Lite (upload.cgi) CGI script is installed.  This script has
a well-known security flaw that lets anyone upload arbitrary files on
the remote web server. 

Note that Nessus did not test whether uploads are possible, only that
the script exists. 

Solution :

Remove the affected script.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if(description)
{
 script_id(11359);
 script_bugtraq_id(7051);
 
 script_version ("$Revision: 1.8 $");
 
 name["english"] = "UploadLite cgi";

 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of upload.cgi";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#

include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

found_files = "";
foreach d ( cgi_dirs() )
{
 loc = string(d, "/upload.cgi");
 req = http_get(item:loc, port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if(res == NULL) exit(0);

 if(
  "<title>PerlScriptsJavascript.com " >< res &&
  "This script must be called" >< res
 ){
  found_files = string(found_files, "  ", loc, "\n");
  if (!thorough_tests) break;
 }
}

if (found_files != ""){
 report = string(
  desc["english"],
  "\n\n",
  "Plugin output :\n",
  "\n",
  "The Upload Lite CGI was found at the following locations :\n",
  "\n",
  "  ", found_files
 );
 security_hole(port:port, data:report);
 exit(0);
}

