#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25990);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-3988");
  script_bugtraq_id(25006);
  script_xref(name:"OSVDB", value:"39368");

  script_name(english:"VHCS Session Fixation Vulnerability");
  script_summary(english:"Tries to use a fixed arbitrary session identifier");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by a
session fixation issue. 

Description :

The remote host is running VHCS, a control panel for hosting
providers. 

The GUI portion of the version of VHCS installed on the remote host
accepts session identifiers from GET (and likely POST) variables,
which makes it susceptible to a session fixation attack.  An attacker
may be able to exploit this issue to gain access to the affected
application using a known session identifier if he can trick a user
into logging in, say, via a specially-crafted link. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-07/0232.html

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/vhcs2", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  url = string(dir, "/index.php");

  # Grab index.php.
  res = http_get_cache(item:url, port:port);
  if (res == NULL) exit(0);

  # Make sure it's VHCS and that a session cookie is being set.
  if (
    ">VHCS - Virtual Hosting Control System<" >< res &&
    'action="chk_login.php" method="post"' >< res &&
    egrep(pattern:"^Set-Cookie:.+PHPSESSID=", string:res)
  )
  {
    # Try to exploit the flaw.
    req = http_get(
      item:string(url, "?PHPSESSID=bc2e59c52cd7a9ae8978014e2110f203"), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if the app doesn't create another session cookie.
    if (
      ">VHCS - Virtual Hosting Control System<" >< res &&
      'action="chk_login.php" method="post"' >< res &&
      !egrep(pattern:"^Set-Cookie:.+PHPSESSID=", string:res)
    )
    {
      security_warning(port);
      exit(0);
    }
  }
}
