#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

An OS Virtualization application is installed on the remote host.

Description :

VMware Workstation, an OS virtualization solution for Desktops and
Laptops that allows to run multiple operating systems on the same
host, is installed on the remote host.

See also :

http://www.vmware.com/products/ws/

Risk factor : 

None.";


if (description)
{
  script_id(26201);
  script_version("$Revision: 1.1 $");

  script_name(english:"VMware Workstation Detection");
  script_summary(english:"Detects if VMware Workstationis installed"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");

name    =  kb_smb_name();
port    =  kb_smb_transport();
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


path = NULL;

key = "SOFTWARE\VMware, Inc.\VMware Workstation";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  # If VMWare is installed...
  item = RegQueryValue(handle:key_h, item:"InstallPath");
  if (!isnull(item))
  {
    path = item[1];
    path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:path);
  }
  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);


if (!path)
{
 NetUseDel();
 exit(0);
}


share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\vmware.exe", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
 NetUseDel();
 exit(0);
}

fh = CreateFile(file:exe, desired_access:GENERIC_READ, file_attributes:FILE_ATTRIBUTE_NORMAL, share_mode:FILE_SHARE_READ, create_disposition:OPEN_EXISTING);
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}

NetUseDel();


if (!isnull(ver))
{
 version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);
 set_kb_item(name:"VMware/Workstation/Version", value:version);

 report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "VMware Workstation version ", version, " is installed under :\n",
          "\n",
          "  ", path, "\n"
    );
 security_note(port:port, data:report);
}
