#
# (C) Tenable Network Security, Inc.
#


if (description)
{
 script_id(26925);
 script_version("$Revision: 1.1 $");

 script_name(english:"VNC Server No Authentication Vulnerability");
 script_summary(english:"Tries to authenticate using a type of None");
 
  desc = "
Synopsis :

The remote VNC server does not require authentication.

Description :

The VNC server installed on the remote host allows an attacker
to connect to the remote host as no authentication is required
to access this service.

Solution :

Disable the No Authentication security type.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 
 script_description(english:desc);
 
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

 script_dependencies("vnc_security_types.nasl");
 script_require_ports("Services/vnc", 5900);

 exit(0);
}

port = get_kb_item("VNC/SecurityNoAuthentication");
if (!isnull(port))
  security_hole(port);

