#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30108);
  script_version("$Revision: 1.3 $");

  script_bugtraq_id(27228);
  script_xref(name:"OSVDB", value:"40218");

  script_name(english:"vTiger CRM Information Disclosure Vulnerability");
  script_summary(english:"Tries to retrieve a directory listing");

  desc = "
Synopsis :

The remote web server contains a PHP application that allows listing
of directory content,

Description :

The remote instance of vTiger allows an unauthenticated attacker to
view the contents of application directories, which could lead to the
disclosure of sensitive information. 

Note that the solution does not prevent an attacker from retrieving
files by guessing their names, only obtaining a directory listing when
one is not otherwise available. 

See also :

http://trac.vtiger.com/cgi-bin/trac.cgi/ticket/2107
http://sourceforge.net/project/shownotes.php?release_id=567189

Solution :

Upgrade to vTiger CRM 5.0.4 RC or later and if necessary rename the
file 'htaccess.txt' in the 'vtigerCRM' directory under the web
server's document root to '.htaccess'. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80, 81);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Some vTiger directories to check.
if (thorough_tests) subdirs = make_list(
  "/test/wordtemplatedownload",
  "/test",
  "/logs",                             # doesn't exist in v4.x
  "/storage"                           # doesn't exist in v4.x
);
else subdirs = make_list("/test/wordtemplatedownload");


# Loop through directories.
if (thorough_tests) dirs = make_list("/vtiger", "/tigercrm", "/crm", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Make sure we're dealing with vTiger.
  res = http_get_cache(item:string(dir, "/index.php"), port:port);
  if (res == NULL) exit(0);

  # If it is...
  if (
    '/vtigercrm_icon.ico">' >< res &&
    '<!-- startscrmprint --><' >< res
  )
  {
    # Try to exploit the issue to view the contents of a couple of directories.
    foreach subdir (subdirs)
    {
      # Make sure we can't get the file ordinarily.
      req = http_get(item:string(dir, subdir, "/"), port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # There's a problem if we get a directory listing.
      if ("<title>Index of "+dir+subdir+"</title>" >< res)
      {
        if (report_verbosity)
        {
          report = string(
            "Here is the directory listing that Nessus retrieved for vtiger CRM's\n",
            subdir, " directory :\n",
            "\n",
            res
          );
          security_warning(port:port, extra:report);
        }
        else security_warning(port);

        exit(0);
      }
    }
  }
}

