# 
# (C) Nicolas Gregoire <ngregoire@exaprobe.com>
#
# Rewritten by Tenable Network Security
#

if(description)
{
 script_id(15910);
 script_version ("$Revision: 1.6 $");
 script_cve_id("CVE-2004-1133");
 script_cve_id("CVE-2004-1134");
 script_bugtraq_id(11820);

 name["english"] = "w3who.dll overflow and XSS";

  
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to execute code on the remote host.

Description :

The Windows 2000 Resource Kit ships with a DLL that displays the browser 
client context. It lists security identifiers, privileges and $ENV variables. 

Nessus has determined that this file is installed on the remote host.

The w3who.dll ISAPI may allow an attacker to execute arbitrary commands 
on this host, through a buffer overflow, or to mount XSS attacks.

See also : 

http://archives.neohapsis.com/archives/fulldisclosure/2004-12/0157.html

Solution : 

Delete this file

Risk factor :

Critical / CVSS Base Score : 10.0 
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of w3who.dll";


 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 Nicolas Gregoire <ngregoire@exaprobe.com>");

 family["english"] = "CGI abuses : XSS";

 script_family(english:family["english"]);
 
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

sig = get_kb_item("www/hmap/" + port + "/description");
if ( sig && "IIS" >!< sig ) exit(0);

req  = http_get(item:"/scripts/w3who.dll", port:port);
res  = http_keepalive_send_recv(port:port, data:req);

if ("Access Token" >< res && "Environment variables" >< res)
{
 req  = http_get(item:"/scripts/w3who.dll?bogus=<script>alert('Hello')</script>", port:port);
 res  = http_keepalive_send_recv(port:port, data:req);

 if ("<script>alert('Hello')</script>" >< res)
   security_hole(port);
}
