#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24864);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-1259");
  script_bugtraq_id(22691);
  script_xref(name:"OSVDB", value:"33272");

  script_name(english:"Webapp.org WebAPP < 0.9.9.6 Multiple Vulnerabilities");
  script_summary(english:"Checks for an XSS flaw in WebAPP");

  desc = "
Synopsis :

The remote web server contains a Perl application that is affected by
multiple issues. 

Description :

The version of WebAPP from webapp.org installed on the remote host is
affected by multiple, as-yet unspecified issues that could be abused
by a remote attacker to completely compromise the affected
application. 

See also :

http://newbc.blackcode.com/forum/index.php?t=msg&th=1167
http://www.web-app.org/cgi-bin/index.cgi?action=viewnews&id=252
http://www.web-app.org/cgi-bin/index.cgi?action=viewnews&id=254

Solution :

Upgrade to webapp.org WebAPP version 0.9.9.6 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("webapp_detect.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


xss = string("'';!--", '"', "<BODY ONLOAD=alert('", SCRIPT_NAME, "')>=&{()}");


# Test an install.
install = get_kb_item(string("www/", port, "/webapp"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Send a request to exploit an XSS flaw.
  referer = string("://", get_host_name(), dir, "/index.cgi");
  if (ENCAPS_IP >= ENCAPS_SSLv23) referer = "https" + referer;
  else referer = "http" + referer;

  url = string(dir, "/index.cgi?action=search");
  postdata = string("pattern=", urlencode(str:xss));
  req = string(
    "POST ", url, " HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Referer: ", referer, "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if our exploit as the language.
  xss = str_replace(find:'"', replace:"&quot;", string:xss);
  if (string('No matches found for <b>"', xss, '"</b>') >< res)
  {
    security_hole(port);
    exit(0);
  }
}
