#
# (C) Tenable Network Security
#


if(description)
{
 script_id(11627);
  script_cve_id("CVE-2003-1224", "CVE-2003-1225", "CVE-2003-1226");
 script_bugtraq_id(7563, 7587);
 script_version ("$Revision: 1.7 $");
 
 
 name["english"] = "WebLogic clear-text passwords";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected to information disclosure issues. 

Description :

The remote web server is running WebLogic 7.0 or 7.0.0.1.

There is a bug in these versions that may allow a local attacker to
recover a WebLogic password if he can see the screen of the WebLogic
server. 

In addition, a local user may be able to view cryptographic secrets,
thereby facilitating cracking of encrypted passwords.

See also :

http://dev2dev.bea.com/resourcelibrary/advisoriesnotifications/BEA03-30.jsp

Solutions : 

Apply Service Pack 3 or later.

Risk factor : 

Low / CVSS Base Score : 1 
(AV:L/AC:L/Au:R/C:P/I:N/A:N/B:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of WebLogic";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003-2006 Tenable Network Security");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service1.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/weblogic");
 exit(0);
}

#

include("http_func.inc");

port = get_http_port(default:80);

if (! get_port_state(port)) exit(0);

banner = get_http_banner(port:port);

if (" Temporary Patch for CR104520" >< banner) exit(0);


if (banner =~ "WebLogic .* 7\.0(\.0\.1)? ")
{
  security_note(port);
  exit(0);
}

