#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# See the Nessus Scripts License for details
#

 desc["english"] = "
Synopsis :

An administration service is running on the remote host.

Description :

The remote server is running Webmin, a web-based interface for
system administration for Unix.

Solution: 

Stop Webmin service if not needed or configure the access
See menu [Webmin Configuration][IP Access Control]
and/or [Webmin Configuration][Port and Address]

See also :

http://www.webmin.net/

Risk factor : 

None";



if(description)
{
 script_id(10757);
 script_version ("$Revision: 1.14 $");
 name["english"] = "Check for Webmin";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Webmin";
 
 script_summary(english:summary["english"],
francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Alert4Web.com");
 family["english"] = "Useless services";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/www", 10000);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

ports = add_port_in_list(list:get_kb_list("Services/www"), port:10000);

foreach port (ports)
{
 banner = get_http_banner(port:port);

 if(banner)
 {
  if(egrep(pattern:"^Server: MiniServ.*",string:banner))
  {
     banner = http_keepalive_send_recv(port:port, data:http_get(item:"/",port:port));
     if(banner != NULL ) {
     if(egrep(pattern:"webmin", string:banner, icase:TRUE))
     {
     set_kb_item(name:"Services/www/webmin", value:port);
     set_kb_item(name:"www/" + port + "/webmin", value:TRUE);

     version = ereg_replace(pattern:".*Webmin *([0-9]\.[0-9][0-9]).*$",
    			    string:banner,
			    replace:"\1");
     if (version == banner) version = 0;
     if (version)
     {
      report = string (desc["english"],
		"\n\nPlugin output :\n\n",
		"The Webmin versio is : ", version);

      security_note(port:port, data:report);
      set_kb_item(name:"webmin/" + port + "/version",value:version); 
     }
     else
       security_note(port);
    }
   }
  }
 }
}
