#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29306);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6312");
  script_bugtraq_id(26793);
  script_xref(name:"OSVDB", value:"39155");

  script_name(english:"Websense Reporting Tools username Parameter Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in Websense Reporting Tools");

  desc = "
Synopsis :

The remote web server contains a script that is affected by a
cross-site scripting vulnerability. 

Description :

The remote host is running Websense, a commercial suite of web
filtering products. 

The remote instance of Websense fails to sanitize user input to the
'UserName' parameter of the 'Websense/cgi-bin/WsCgiLogin.exe' script
before using it to generate dynamic content.  An unauthenticated
remote attacker may be able to leverage this issue to inject arbitrary
HTML or script code into a user's browser to be executed within the
security context of the affected site. 

See also :

http://www.nessus.org/u?430117ea
http://archives.neohapsis.com/archives/bugtraq/2007-12/0124.html
http://www.websense.com/SupportPortal/SupportKbs/1840.aspx

Solution :

Apply the Hotfix referenced in the vendor advisory above.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 80;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Try to exploit the issue.
xss = string("<script>alert('", SCRIPT_NAME, "')</script>");
exploit = string('nessus">', xss);

req = http_get(
  item:string(
    "/Websense/cgi-bin/WsCgiLogin.exe?",
    "Page=login&",
    "UserName=", urlencode(str:exploit)
  ), 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);

# There's a problem if...
if (
  # it's Websense and ...
  'alt="Websense.com"' >< res && 
  # the output complains about our "user name".
  ' name="UserName"' >< res &&
  string('value="', exploit, '">') >< res
)
{
  security_warning(port);
  exit(0);
}
