#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote web server uses a web application framework that is
operating in development mode. 

Description :

The remote web server is using WebSpeed, a website creation language
used with database-driven websites. 

The installation of WebSpeed on the remote host is configured to
operate in 'Development' rather than 'Production' mode, which may
allow users to discover sensitive information and even run uncompiled
WebSpeed code on the affected host, subject to the privileges of the
web server user id. 

See also :

http://www.psdn.com/library/servlet/KbServlet/download/1107-102-926/wpb.pdf

Solution :

Change WebSpeed's Agent Application Mode to 'Production' if desired. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25087);
  script_version("$Revision: 1.4 $");

  script_name(english:"WebSpeed Development Mode Check");
  script_summary(english:"Checks if WebSpeed is in Development mode"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/scripts", "/cgi-public", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Loop over various standard WebSpeed Messenger scripts.
  foreach msgr (make_list("cgiip.exe", "wsisa.dll", "wsasp.dll", "wsnsa.dll", "wspd_cgi.sh"))
  {
    # See whether we can access the ping tool successfully.
    uri = string(dir, "/", msgr, "/WService=wsbroker1/webutil/ping.p");
    req = http_get(item:uri, port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if it looks like we were successful.  
    if (
      "<TITLE>WebSpeed Agent successfully accessed</TITLE>" >< res ||
      (
        "<!-- Generated by WebSpeed " >< res &&
        "Testing....... OK" >< res
      )
    )
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able to access the Ping tool via the following URI :\n",
        "\n",
        "  ", uri, "\n"
      );
      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
