#
# (C) Tenable Network Security
#

if(description)
{
 script_id(23638);
 script_bugtraq_id(20455);
 script_version("$Revision: 1.2 $");
 
 name["english"] = "IBM WebSphere Application Server '%20' source disclosure";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure flaw. 

Description :

It is possible to make the remote web server disclose the source code
of its JSP pages by requesting the .jsp file with a '%20' appended to
the request. 

An attacker may use this flaw to get the source code of your CGIs and
possibly to obtain passwords and other relevant information about this
host. 

See also :

http://www-1.ibm.com/support/docview.wss?rs=180&uid=swg24013142

Solution : 

Apply version 6.1.0 Fix Pack 2 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Attempts to read the source of a jsp page";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("webmirror.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

function check(file)
{
    local_var f, pos, req, res;
    global_var port;

    pos[0] = "<%@ page language";
    pos[1] = "<jsp:useBean";
    pos[2] = "<%@ page import";
    req = string("GET " + file + "%20 HTTP/1.1\r\n" +
"Host: " , get_host_name(),  "\r\n" + 
"Pragma: no-cache\r\n" +
"User-Agent: Mozilla/4.0 (compatible, MSIE 6.0, Windows NT 5.0)\r\n" + 
"Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*\r\n" + 
"Accept-Language: en\r\n" + 
"Accept-Charset: iso-8859-1,*,utf-8\r\n\r\n");

    res = http_keepalive_send_recv(port:port, data:req);
    if( res == NULL )
    {
	return 0; 
    }
    else
    {
	foreach f (pos)
	{
	    if (f >< res)
		return 1;
	}
    }
    return 0;

}

port = get_http_port(default:80);

if(get_port_state(port))
{
    banner = get_http_banner(port:port);
    if (!banner || "Server: WebSphere Application Server" >!< banner) exit(0);

    files = get_kb_list(string("www/", port, "/content/extensions/jsp"));
    if(isnull(files))
	files = make_list("/index.jsp");
    n = 0;
    foreach file (files)
    {
  	if(check(file:file) == 1)
   	{
	    security_warning(port);
	    exit(0);
  	}
  	n++;
  	if(n > 20)
	    exit(0);
    }
}
