#
# (C) Tenable Network Security
#


 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure flaw. 

Description :

This script attempts to enumerate the actual physical path of the
servlet classes by requesting a version of 'snoopservlet' which is
missing required classes.  An attacker, gaining information about the
actual physical layout of the file system, can use the information in
crafting more complex attacks. 

Solution :

If not required, uninstall the default applications. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if(description)
{
 script_id(23639);
 script_version ("$Revision: 1.3 $");
 
 name["english"] = "Snoop Servlet path disclosure";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Attempts to enumerate physical path";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "webmirror.nasl", "http_version.nasl", "DDI_Directory_Scanner.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


files[0] = "SnoopServlet";
files[1] = "snoopservlet";

port = get_http_port(default:80);


if(!get_port_state(port))
	exit(0);

dirs = get_kb_list(string("www/", port, "/content/directories"));
if (isnull(dirs)) dirs = make_list();
dirs = make_list(dirs, "/servlet");

totalcounter = 0;
foreach d (dirs)
{
	foreach f (files)
	{
		req = string(d,"/",f,"/");
		req = http_get(item:req, port:port);
		r = http_keepalive_send_recv(port:port, data:req);
		if ( "servlet was originally compiled with classes which cannot be located by the server" >< r ||
		     egrep(string:r, pattern:"classpath=\[[a-zA-Z]:\\.*\.jar")  )
		{
			report = string(
				desc["english"],
				"\n\n",
				"Plugin output :\n",
				"\n",
				"The following file, when requested, will leak information\n",
				"regarding the local configuration :\n",
				"\n",
				"  ", d, "/", f, "/\n"
			);
			security_warning(port:port, data:report);
			exit(0);
		}
	}
}
