#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23649);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2006-2431");
  script_bugtraq_id(17919);
  script_xref(name:"OSVDB", value:"30944");

  script_name(english:"IBM WebSphere Application Server SOAP Connector Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in WebSphere Application Server's SOAP Connector");

  desc = "
Synopsis :

The remote SOAP server is vulnerable to a cross-site scripting attack. 

Description :

The remote SOAP server fails to sanitize user input via the URI before
using it to generate dynamic XML content in an error page.  An
unauthenticated remote attacker may be able to leverage this issue to
inject arbitrary XML into a user's browser. 

See also :

http://www.securityfocus.com/archive/1/450704/30/0/threaded
http://www.niscc.gov.uk/niscc/docs/br-20061031-00728.html?lang=en
http://www-1.ibm.com/support/search.wss?rs=0&q=PK16602&apar=only

Solution :

Apply version 5.0.2 Cumulative Fix 17 / 5.1.1 Cumulative Fix 12 /
6.0.2 Fix Pack 9, depending on the installed version of IBM WebSphere
Application Server. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("soap_detect.nasl");
  script_require_ports("Services/soap_http", 8880);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_kb_item("Services/soap_http");
if (!port) port = 8880;
if (!get_port_state(port)) exit(0);


# Make sure the banner is for WebSphere.
banner = get_http_banner(port:port);
if (!banner || "Server: WebSphere Application Server" >!< banner) exit(0);


# Send a request to exploit the flaw.
xss = string("/<nessus>", SCRIPT_NAME, "</nessus>");
req = http_get(item:xss, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if our exploit appears in 'faultactor' as-is.
if (string("<faultactor>", xss, "</faultactor>") >< res) 
  security_warning(port);

