#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25684);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3681");
  script_bugtraq_id(24829);
  script_xref(name:"OSVDB", value:"37889");

  script_name(english:"WinPcap NPF.SYS Local Privilege Escalation Vulnerability");
  script_summary(english:"Checks version of NPF.SYS");
 
 desc = "
Synopsis :

The remote Windows host contains an application that is prone to a
local privilege escalation vulnerability. 

Description :

WinPcap, a packet capture and filtering engine, is installed on the
remote Windows host. 

The version of WinPcap on the remote host enables a local user to
execute arbitrary code in kernel context because it fails to
sufficiently sanitize Interrupt Request Packet parameters before
passing them to the BIOCGSTATS IOCTL. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=550
http://www.securityfocus.com/archive/1/473223/30/0/threaded
http://www.winpcap.org/misc/changelog.htm

Solution :

Upgrade to WinPcap version 4.0.1 or later.

Risk factor : 

Medium / CVSS Base Score : 6.6
(CVSS2#AV:L/AC:M/Au:S/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_enum_services.nasl", "smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Make sure it's installed.
path = NULL;
key = "SOFTWARE\WinPcap";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:NULL);
  if (!isnull(value))
  {
    path = value[1];
    path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:path);
  }
  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}


# Grab the file version of the affected file.
winroot = hotfix_get_systemroot();
if (!winroot) exit(1);

share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:winroot);
sys =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\System32\drivers\npf.sys", string:winroot);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:sys,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}


# Check the version number.
if (!isnull(ver))
{
  # nb: 4.0.0.901 is the file version from version 4.0.1.
  fix = split("4.0.0.901", sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      security_warning(port);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}


# Clean up.
NetUseDel();
