#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# 
#
# See the Nessus Scripts License for details
#
# Affected: wu-ftpd up to 2.6.1


if(description)
{
 script_id(11331);
 script_version ("$Revision: 1.7 $");

 script_cve_id("CVE-2001-0187");
 script_bugtraq_id(2296);
 script_xref(name:"OSVDB", value:"1744");
 
 name["english"] = "wu-ftpd PASV format string";
 
 script_name(english:name["english"]);
	     
 desc["english"] = "
Synopsis :

The remote FTP server is prone to a format string vulnerability. 

Description :

The remote WU-FTPd server, according to its version number, is
vulnerable to a format string attack when running in debug mode. 

See also :

http://www.wu-ftpd.org/CHANGES

Solution : 

Upgrade to WU-FTPD version 2.6.2 or later.

Risk factor :

Low / CVSS Base Score : 3.4
(AV:R/AC:H/Au:R/C:P/I:P/A:P/B:N)";
 script_description(english:desc["english"]);
		    
 script_summary(english:"Checks the remote ftpd version");
 script_category(ACT_GATHER_INFO); 
 script_family(english:"FTP");
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 2003 Renaud Deraison");
		  
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here : 
#

include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port) port = 21;

banner = get_ftp_banner(port:port);
if(banner)
{
  banner = tolower(banner);
  if(egrep(pattern:"wu-((1\..*)|2\.([0-5]\..*|6\.[0-1]))", string:banner))
  	security_note(port);
}
