#
# (C) Tenable Network Security, Inc.
#

 desc = "
Synopsis :

The remote web server might transmit credentials over clear text

Description :

The remote web server contains several HTML forms containing
an input of type 'password' which transmit their information to
a remote web server over plain text.

An attacker eavesdropping the traffic might use this setup to
obtain logins and passwords of valid users.

Solution :

Make sure that every form transmits its results over HTTPS

Risk factor:

Medium / CVSS Base Score : 5.0 
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

if(description)
{
 script_id(26194);
 script_version ("$Revision: 1.3 $");

 script_name(english: "Web Server Uses Plain Text Authentication Forms");
 
 script_description(english:desc);

 script_summary(english: "Uses the results of webmirror.nasl");
 script_category(ACT_GATHER_INFO); 
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 script_family(english: "Web Servers");
 script_dependencie("webmirror.nasl");
 script_require_ports("Services/www",80);
 exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);
if ( ! port ) exit(0);

kb = get_kb_item("www/" + port + "/ClearTextPasswordForms");
if ( kb )
 security_warning(port:port, data:desc + '\n\nPlugin output :\n\n' + kb);
