#
# (C) Tenable Network Security
#

if(description)
{
 script_id(24245);
 script_version("$Revision: 1.3 $");
 script_cve_id("CVE-2006-3436");

 name["english"] = "Vulnerabilities in ASP.NET could allow information disclosure (922770) (network check)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote .Net Framework is vulnerable to a cross site scripting attack.

Description :

The remote host is running a version of the ASP.NET framework which contains
contains a cross site scripting vulnerability which could allow an attacker
to execute arbitrary code in the browser of the users visiting the remote
web site.

Solution : 

Microsoft has released a set of patches for Windows 2000, XP and 2003 :

http://www.microsoft.com/technet/security/bulletin/ms06-056.mspx

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of the ASP.Net DLLs via HTTP";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("dotnet_framework_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if (! port )exit(0);
ver = get_kb_item("www/" + port + "/ASP.NET_Version");
if ( ! ver ) exit(0);

v = split(ver, sep:'.', keep:FALSE);
for ( i = 0 ; i < max_index(v) ; i ++ ) v[i] = int(v[i]);

if ( ! isnull(v) ) 
       if ( (v[0] == 2 && v[1] == 0 && v[2] == 50727 && v[3] < 210 ) ) security_warning(port);
