#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25117);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-2079");
  script_bugtraq_id(23491);

  script_name(english:"XAMPP ADOdb mssql_connect Buffer Overflow Vulnerability");
  script_summary(english:"Tries to generate an error with mssql_connect");

  desc = "
Synopsis :

The remote web server is prone to a buffer overflow attack. 

Description :

The remote host is running XAMPP, an Apache distribution containing
MySQL, PHP, and Perl.  It is designed for easy installation and
administration. 

The remote version of XAMPP includes a PHP interpreter that is
affected by a buffer overflow involving calls to 'mssql_connect()' as
well as an example PHP script that allows this function to be called
with arbitrary arguments.  Using a specially-crafted value for the
'host' parameter of the 'xampp/adodb.php' script, an unauthenticated
remote attacker can leverage these issues to execute arbitrary code on
the affected host subject to the privileges under which the web server
operates, potentially LOCAL SYSTEM. 

See also :

http://packetstorm.linuxsecurity.com/0704-exploits/xampp-rgod.txt
http://www.apachefriends.org/en/news-article,100366.html
http://www.apachefriends.org/en/xampp-windows.html#1221

Solution :

Use XAMPP's Security Console to restrict access to the '/xampp'
directory. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Make sure the affected script exists.
url = "/xampp/adodb.php";
req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If it does...
if (
  'name="dbserver"' >< res &&
  '<meta name="author" content="Kai Oswald Seidler' >< res
)
{
  # Unless we're being paranoid, just flag the flaw.
  if (report_paranoia < 2)
  {
    security_hole(port);
    exit(0);
  }

  # See if we have control over parameters to mssql_connect().
  postdata = string(
    "dbserver=mssql&",
    "host=", crap(500), "&",
    "adodb=submit&",
    "user=1&",
    "password=1&",
    "database=nessus&",
    "table=", SCRIPT_NAME
  );
  req = string(
    "POST ", url, " HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Referer: ", referer, "\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If so...
  if (string('mssql error: [: ] in EXECUTE("SELECT * FROM ', SCRIPT_NAME, '")') >< res)
  {
    security_hole(port);
    exit(0);
  }
}
