#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

An X font service is listening on the remote host. 

Description :

The remote service is an X Window Font Service (xfs) daemon, which
serves font files to clients. 

See also :

http://www.x.org/docs/FSProtocol/fsproto.pdf
http://en.wikipedia.org/wiki/X_Font_Server

Solution :

Limit incoming traffic to this port if desired or disable the service
as the use of server-supplied fonts is currently deprecated. 

Risk factor :

None";


if (description)
{
  script_id(26971);
  script_version("$Revision: 1.3 $");

  script_name(english:"X Font Service Detection");
  script_summary(english:"Sends an initial connection request");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 7100);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery") )
{
  port = get_unknown_svc(7100);
  if (!port) exit(0);
  if (silent_service(port) ) exit(0);
}
else port = 7100;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Try to open a connection.
set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);

req = 'l' +                            # we're using little-endian byte order
  mkbyte(0) +                          # number of auth
  mkword(0x02) + mkword(0x00) +        # client protocol version (major/minor)
  mkword(0x00);                        # authorization protocols (empty)
send(socket:soc, data:req);


# Read the reply.
res = recv(socket:soc, length:512, min:6);
if (strlen(res) < 6) exit(0);

# Parse response elements that appear regardless of the status.
#
# - status
status = getword(blob:res, pos:0);
# - protocol
proto_maj = getword(blob:res, pos:2);
proto_min = getword(blob:res, pos:4);
# - alternate servers
n_alt = getbyte(blob:res, pos:6);
len_alt = getword(blob:res, pos:8) * 4;
if (n_alt && len_alt) list_alt = substr(res, 12, 12+len_alt-1);
else list_alt = "";
# - authorization protocols
auth_index = getbyte(blob:res, pos:7);
len_auth = getword(blob:res, pos:10) * 4;
if (auth_index && len_auth) list_auth = substr(res, 12+len_alt, 12+len_alt+len_auth-1);
else list_auth = "";


# If...
if (
  # Status is Success and auth_index is 0 or...
  (status == 0 && auth_index == 0) ||
  # Status is Continue and auth_index indexes into the authorization protocols or...
  (status == 1 && auth_index >= 1 && auth_index <= len_auth/4) ||
  # Status is Busy and auth_index is 0 or...
  (status == 2 && auth_index == 0) ||
  # Status is Denied and auth_index is 0
  (status == 3 && auth_index == 0)
)
{
  # Extract some info for the report.
  info = "";
  # - protocol version.
  info += "  Protocol                   : " + proto_maj + '.' + proto_min + '\n';
  # - alternate servers.
  info += "  Alternate servers          : ";
  if (n_alt)
  {
    info += '\n';
    j = 12+1;
    for (i=0; i<n_alt && j < strlen(res); i++)
    {
      l = getbyte(blob:res, pos:j);
      alt = substr(res, j+1, j+l);
      info += "    " + alt + '\n';
      j+= l+2;
    }
  }
  else info += 'none\n';
  # - other items if status indicates success.
  if (0 == status)
  {
    i = 12+len_alt+len_auth;
    len_rest = getdword(blob:res, pos:i);
    # - max request size.
    max_req = getword(blob:res, pos:i+4);
    info += "  Max request size           : " + 4*max_req + ' bytes\n';
    # - release.
    release = getdword(blob:res, pos:i+8);
    info += "  Vendor release             : " + release + '\n';
    # - vendor.
    len_vendor = getword(blob:res, pos:i+6);
    if (len_vendor)
    {
      vendor = substr(res, i+12, i+12+len_vendor-1);
      info += "  Vendor string              : " + vendor + '\n';
    }
    # - list of available fonts.
    #   nb: this won't work properly if max_fonts is so high that the response 
    #       gets split into multiple response packets. 
    max_fonts = 15;
    req2 = mkbyte(0x0d) +              # ListFonts
      mkbyte(0) +                      # unused
      mkword(0x04) +                   # 3+(n+p)/4
      mkdword(max_fonts) +             # max names
      mkword(0x01) +                   # length of pattern (n)
      mkword(0x00) +                   # unused
      "*" +                            # pattern
      crap(data:mkbyte(0x00), length:3); # pad (p)
    send(socket:soc, data:req2);
    res2 = recv(socket:soc, length:6000, min:6);
    if (
      strlen(res2) >= 16 &&
      0 == getbyte(blob:res2, pos:0) &&
      1 == getword(blob:res2, pos:2) &&
      max_fonts >= getdword(blob:res2, pos:12)
    )
    {
      info += "  Available fonts (up to " + max_fonts + ") : " + '\n';
      nfonts = getdword(blob:res2, pos:12);
      j = 0x10;
      for (i=0; i<nfonts && j < strlen(res2); i++)
      {
        l = getbyte(blob:res2, pos:j);
        font = substr(res2, j+1, j+l);
        info += "    " + font + '\n';
        j+= l+1;
      }
    }
  }

  # Register and report the service.
  register_service(port:port, proto:"xfs");

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus was able to gather the following information from the remote\n",
    "X Font Server :\n",
    "\n",
    info
  );
  security_note(port:port, data:report);
}
