#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is susceptible to
multiple buffer overflow attacks. 

Description :

The remote host contains the Zoomify Viewer ActiveX control, used to
incorporate zoomable images into web sites. 

The version of this control on the remote host is reportedly affected
by multiple stack buffer overflows.  If an attacker can trick a user
on the affected host into visiting a specially-crafted web page, he
may be able to leverage these issues to execute arbitrary code on the
host subject to the user's privileges. 

See also :

http://www.kb.cert.org/vuls/id/174177

Solution :

Disable the use of this ActiveX control from within Internet Explorer
by setting its 'kill' bit. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25460);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2920");
  script_bugtraq_id(24421);
  script_xref(name:"OSVDB", value:"37207");

  script_name(english:"Zoomify Viewer ActiveX Buffer Overflow Vulnerabilities");
  script_summary(english:"Checks versions of Zoomify Viewer ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate files used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{F7DC2A2E-FC34-11D3-B1D9-00A0C99B41BB}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  report = NULL;
  if (report_paranoia > 1)
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "According to the registry, the vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n",
      "\n",
      "Note, though, that Nessus did not check whether the 'kill' bit was\n",
      "set for the control's CLSID because of the Report Paranoia setting\n",
      "in effect when this scan was run.\n"
    );
  else if (activex_get_killbit(clsid:clsid) != TRUE)
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "According to the registry, the vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n",
      "\n",
      "Moreover, its 'kill' bit is not set so it is accessible via\n",
      "Internet Explorer."
    );
  if (report) security_hole(port:kb_smb_transport(), data:report);
}
activex_end();
